#############################################################################
##
##  PackageInfo.g for the package `automgrp'
##

SetPackageInfo(rec(

##  This is case sensitive, use your preferred spelling.
#
PackageName := "AutomGrp",

##  This may be used by a default banner or on a Web page, should fit on
##  one line.
Subtitle := "Automata groups",

Version := "1.1.4.1",

##  Release date of the current version in dd/mm/yyyy format.
#
Date := "19/09/2008",

ArchiveURL := "http://downloads.sourceforge.net/finautom/automgrp-1.1.4.1",

ArchiveFormats := ".tar.bz2 .tar.gz -win.zip",

Persons := [
  rec(
    LastName      := "Muntyan",
    FirstNames    := "Yevgen",
    IsAuthor      := true,
    IsMaintainer  := true,
    Email         := "muntyan@math.tamu.edu",
    WWWHome       := "http://www.math.tamu.edu/~muntyan/",
    PostalAddress := "",
    Place         := "College Station, TX, USA",
    Institution   := "Texas A&M University"
  ),
  rec(
    LastName      := "Savchuk",
    FirstNames    := "Dmytro",
    IsAuthor      := true,
    IsMaintainer  := true,
    Email         := "dmytro.savchuk@gmail.com",
    WWWHome       := "http://www.math.tamu.edu/~savchuk/",
    PostalAddress := "",
    Place         := "College Station, TX, USA",
    Institution   := "Texas A&M University"
  ),
],

Status := "deposited",

##  You must provide the next two entries if and only if the status is
##  "accepted" because is was successfully refereed:
# format: 'name (place)'
# CommunicatedBy := "Mike Atkinson (St. Andrews)",
#CommunicatedBy := "",
# format: mm/yyyy
# AcceptDate := "08/1999",
#AcceptDate := "",

README_URL := "http://finautom.sourceforge.net/automgrp/README",
PackageInfoURL := "http://finautom.sourceforge.net/automgrp/PackageInfo.g",

##  Here you  must provide a short abstract explaining the package content
##  in HTML format (used on the package overview Web page) and an URL
##  for a Webpage with more detailed information about the package
##  (not more than a few lines, less is ok):
##  Please, use '<span class="pkgname">GAP</span>' and
##  '<span class="pkgname">MyPKG</span>' for specifing package names.
##
AbstractHTML := "The <span class=\"pkgname\">AutomGrp</span> package provides \
methods for computations with groups and semigroups generated by finite automata \
or given by wreath recursion, as well as with their finitely generated subgroups \
and elements.",

PackageWWWHome := "http://finautom.sourceforge.net/",

PackageDoc := rec(
 # use same as in GAP
 BookName  := "AutomGrp",
 # format/extension can be one of .zoo, .tar.gz, .tar.bz2, -win.zip
#  Archive := "",
 ArchiveURLSubset := ["doc", "htm"],
 HTMLStart := "htm/chapters.htm",
 PDFFile   := "doc/manual.pdf",
 # the path to the .six file used by GAP's help system
 SixFile   := "doc/manual.six",
 # a longer title of the book, this together with the book name should
 # fit on a single text line (appears with the '?books' command in GAP)
 # LongTitle := "Elementary Divisors of Integer Matrices",
 LongTitle := "Automata Groups",
 # Should this help book be autoloaded when GAP starts up? This should
 # usually be 'true', otherwise say 'false'.
 Autoload  := true
),

##  Are there restrictions on the operating system for this package? Or does
##  the package need other packages to be available?
Dependencies := rec(
  # GAP version, use version strings for specifying exact versions,
  # prepend a '>=' for specifying a least version.
  GAP := ">=4.4.6",
  # list of pairs [package name, (least) version],  package name is case
  # insensitive, least version denoted with '>=' prepended to version string.
  # without these, the package will not load
  # NeededOtherPackages := [["GAPDoc", ">= 0.99"]],
  NeededOtherPackages := [["FGA", ">= 1.1.0.1"]],
  # without these the package will issue a warning while loading
  # SuggestedOtherPackages := [],
  SuggestedOtherPackages := [],
  # needed external conditions (programs, operating system, ...)  provide
  # just strings as text or
  # pairs [text, URL] where URL  provides further information
  # about that point.
  # (no automatic test will be done for this, do this in your
  # 'AvailabilityTest' function below)
  # ExternalConditions := []
  ExternalConditions := []
),

AvailabilityTest := ReturnTrue,

##  The LoadPackage mechanism can produce a default banner from the info
##  in this file. If you are not happy with it, you can provide a string
##  here that is used as a banner. GAP decides when the banner is shown and
##  when it is not shown. *optional* (note the ~-syntax in this example)
#BannerString := Concatenation(
#  "----------------------------------------------------------------\n",
#  "Loading  Example ", ~.Version, "\n",
#  "by ", ~.Persons[1].FirstNames, " ", ~.Persons[1].LastName,
#        " (", ~.Persons[1].WWWHome, ")\n",
#  "   ", ~.Persons[2].FirstNames, " ", ~.Persons[2].LastName,
#        " (", ~.Persons[2].WWWHome, ")\n",
#  "For help, type: ?Example package \n",
#  "----------------------------------------------------------------\n" ),

##  Suggest here if the package should be *automatically loaded* when GAP is
##  started.  This should usually be 'false'. Say 'true' only if your package
##  provides some improvements of the GAP library which are likely to enhance
##  the overall system performance for many users.
Autoload := false,

##  *Optional*, but recommended: path relative to package root to a file which
##  contains as many tests of the package functionality as sensible.
TestFile := "tst/testall.g",

##  *Optional*: Here you can list some keyword related to the topic
##  of the package.
# Keywords := ["Smith normal form", "p-adic", "rational matrix inversion"]
Keywords := ["finite automata", "tree automorphisms", "self-similar groups", "wreath recursion"]

));


