InstallGlobalFunction(FactorizationNParts, # decompose a positive integer d into product of n integers
function(d,n)
local t,faclst,x,w,y,j;
      
if n=1 then return [[d]];fi;
###

t:=DivisorsInt(d);
faclst:=[];
for x in t do
y:=FactorizationNParts(d/x,n-1);
for j in y do
Add(faclst,AddFirst(j,x));
od;
od;
return faclst;
end);

#########################################
InstallGlobalFunction(CrystGFullBasis,    # search for a G-fullbasis of a G-lattice 
                                          # for the given crystallographic G generated by 
					   # the set of generators S
function(arg)
local G,P,Bt,d,n,
      i,j,a,faclst,S,gens,
      B_delta,ctr,v,
      x,SbGrp,T,coef;
      
if IsGroup(arg[1]) then 
gens:=GeneratorsOfGroup(arg[1]);
else gens:=arg[1];
fi;
G:=AffineCrystGroup(gens);
SbGrp:=TranslationSubGroup(G);
Bt:=G!.TranslationBasis;
S:=RightTransversal(G,SbGrp);
P:=PointGroup(G);
n:=G!.DimensionOfMatrixGroup-1;
d:=DivisorsInt(Order(P));
i:=Length(d);

##########

while i>0 do
faclst:=FactorizationNParts(d[i],n);
for x in faclst do
 B_delta:=List([1..n],i->x[i]^-1*Bt[i]);
 if IsCrystSufficientLattice(B_delta,S) then 
 ctr:=Sum(B_delta)/2;
 coef:=CombinationDisjointSets(x);
 j:=1;
 while j <= d[i] do
  v:=ctr+coef[j]*B_delta;
  if IsCrystSameOrbit(G,Bt,S,ctr,v)=false then break;fi;
  j:=j+1;
 od;
 if j=d[i]+1 then return B_delta;fi;
fi;
od;
i:=i-1;
od;
return false;
end);