package com.DUNS;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
//import android.app.NotificationManager;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import android.widget.Toast;

public class DUNService extends Service {
//	private NotificationManager mNM;
	
	@Override
	public IBinder onBind(Intent arg0) {
		// TODO Auto-generated method stub
		return null;
	}
    private static final String TAG = "DUNService";
    private static final boolean D = false;

    // Message types sent from the BluetoothChatService Handler
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;

    // Key names received from the BluetoothChatService Handler
    public static final String DEVICE_NAME = "device_name";
    public static final String TOAST = "toast";
    
    private Process pppprocess;
    private String pppptyname;
    private BufferedInputStream pppin = null;
    private FileOutputStream pppout = null;

    // Name of the connected device
    private String mConnectedDeviceName = null;
    // Local Bluetooth adapter
    private BluetoothAdapter mBluetoothAdapter = null;
    // Member object for the chat services
    private BluetoothChatService mChatService = null;


    @Override
    public void onCreate() {
        if(D) Log.e(TAG, "+++ ON CREATE +++");

//		mNM = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);

//        Toast.makeText(this, "Bluetooth DUNS created", Toast.LENGTH_LONG).show();
        // Get local Bluetooth adapter
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

        // If the adapter is null, then Bluetooth is not supported
        if (mBluetoothAdapter == null) {
            Toast.makeText(this, "Bluetooth is not available", Toast.LENGTH_LONG).show();
            stopSelf();
            return;
        }
        
        try {
        	InputStream is = getAssets().open("pppd2mx.arm");
       	 	int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();

        	FileOutputStream os =  openFileOutput("pppd2mx.arm", Context.MODE_PRIVATE);
        	os.write(buffer);
        	os.close();

        	is = getAssets().open("setup.sh");
       	 	size = is.available();
            buffer = new byte[size];
            is.read(buffer);
            is.close();

        	os =  openFileOutput("setup.sh", Context.MODE_PRIVATE);
        	os.write(buffer);
        	os.close();
        	
        	Process p = Runtime.getRuntime().exec("/system/bin/chmod 0755 /data/data/com.DUNS/files/pppd2mx.arm");
        	p.waitFor();
        	p = Runtime.getRuntime().exec("/system/bin/chmod 0755 /data/data/com.DUNS/files/setup.sh");
        	p.waitFor();
        	p =Runtime.getRuntime().exec("/data/data/com.DUNS/files/setup.sh");
        	p.waitFor();
        } catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
//        Toast.makeText(this, "Bluetooth DUNS starting", Toast.LENGTH_LONG).show();
        if(D) Log.e(TAG, "++ ON START ++");
            if (mChatService == null) setupChat();
        return START_STICKY;
    }

    private void setupChat() {
        Log.d(TAG, "setupChat()");
//        Toast.makeText(this, "Bluetooth DUNS starting chat", Toast.LENGTH_LONG).show();

        // Initialize the BluetoothChatService to perform bluetooth connections
        mChatService = new BluetoothChatService(this, mHandler);
        mChatService.start();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        // Stop the Bluetooth chat services
        if (mChatService != null) mChatService.stop();
        if(D) Log.e(TAG, "--- ON DESTROY ---");
    }

    /**
     * Sends a message.
     * @param message  A string of text to send.
     */
    private synchronized void sendMessage(String message) {
        // Check that we're actually connected before trying anything
        if (mChatService.getState() != BluetoothChatService.STATE_CONNECTED) {
            Toast.makeText(this, R.string.not_connected, Toast.LENGTH_SHORT).show();
            return;
        }

        // Check that there's actually something to send
        if (message.length() > 0) {
            // Get the message bytes and tell the BluetoothChatService to write
            byte[] send = message.getBytes();
            mChatService.write(send);
        }
    }
    
    private synchronized void sendMessage(byte[] message, int len) {
        // Check that we're actually connected before trying anything
        if (mChatService.getState() != BluetoothChatService.STATE_CONNECTED) {
            Toast.makeText(this, R.string.not_connected, Toast.LENGTH_SHORT).show();
            return;
        }

        // Check that there's actually something to send
        if (message.length > 0) {
            // Get the message bytes and tell the BluetoothChatService to write
            mChatService.write(message, len);
        }
    }

    public String PPPrun() {
/*
    	try {
			pppin = new BufferedInputStream(new FileInputStream("/dev/ptyp6"));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

    	try {
			pppout = new FileOutputStream("/dev/ptyp6");
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
*/
    	try { 
    	    pppprocess = Runtime.getRuntime().exec("/data/data/com.DUNS/files/pppd2mx.arm /dev/pts/17 local nodetach passive persist 10.123.214.6:10.123.214.7");
//    	    pppprocess = Runtime.getRuntime().exec("/system/bin/pppd /dev/ttyp6 local passive persist 10.123.214.6:10.123.214.7");
            Toast.makeText(this, "PPP started", Toast.LENGTH_SHORT).show();
//s    	    mTitle.append(" PPP");
    	    return "/dev/pts/" +  Integer.toString(pppprocess.waitFor());
    	        	    
    	} catch (IOException e) {
    	} catch (InterruptedException e) {
		}
    	return "";

    };
    
    private class PPPThread extends Thread {
        PPPThread() {
        }

        public void run() {
        	try {
        	    int rd;
        	    byte[] buffer = new byte[4096];
        	    while (true) {
        	    	if ((rd = pppin.read(buffer, 0, 1600)) > 0) {
        	    		sendMessage(buffer, rd);
        	    	}
        	    	Thread.sleep(1);
        	    }        	    
        	} catch (IOException e) {
        		pppin = null;
        		pppout = null;
        		mChatService.start();
        	} catch (InterruptedException e) {
        		pppin = null;
        		pppout = null;
        		mChatService.start();
			}               	

        }
    }

    private PPPThread PPP;

    // The Handler that gets information back from the BluetoothChatService
    private final Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
            case MESSAGE_STATE_CHANGE:
                if(D) Log.i(TAG, "MESSAGE_STATE_CHANGE: " + msg.arg1);
                switch (msg.arg1) {
                case BluetoothChatService.STATE_CONNECTED:
//s                    mTitle.setText(R.string.title_connected_to);
//s                    mTitle.append(mConnectedDeviceName);
//s                    mConversationArrayAdapter.clear();
                    Toast.makeText(DUNService.this, "Connected to "+ mConnectedDeviceName, Toast.LENGTH_SHORT).show();
                    break;
                case BluetoothChatService.STATE_CONNECTING:
//s                    mTitle.setText(R.string.title_connecting);
                    break;
                case BluetoothChatService.STATE_LISTEN:
                case BluetoothChatService.STATE_NONE:
                	pppout = null;
                	pppin = null;
                    Toast.makeText(DUNService.this, "Disconnected", Toast.LENGTH_SHORT).show();
//s                    mTitle.setText(R.string.title_not_connected);
                    break;
                }
                break;
            case MESSAGE_WRITE:
                break;
            case MESSAGE_READ:
                byte[] readBuf = (byte[]) msg.obj;
                
                if(pppout!=null) {
                	try {
                		if(msg.arg1>0) pppout.write(readBuf, 0, msg.arg1);
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
                } else {
                    // construct a string from the valid bytes in the buffer
                    String readMessage = new String(readBuf, 0, msg.arg1);
            
                if(readMessage.startsWith("ATDT")) {
                	DUNService.this.sendMessage("CONNECT\r");

                	pppptyname = PPPrun();

                	try {
						pppin = new BufferedInputStream(new FileInputStream(pppptyname));
					} catch (FileNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}

                	try {
						pppout = new FileOutputStream(pppptyname);
					} catch (FileNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					
                	PPP = new PPPThread();
                	PPP.start();
                	
                	
                } else
                if(readMessage.startsWith("AT")) DUNService.this.sendMessage("OK\r");
                }
                break;
            case MESSAGE_DEVICE_NAME:
                // save the connected device's name
                mConnectedDeviceName = msg.getData().getString(DEVICE_NAME);
                Toast.makeText(getApplicationContext(), "Connected to "
                               + mConnectedDeviceName, Toast.LENGTH_SHORT).show();
                break;
            case MESSAGE_TOAST:
                Toast.makeText(getApplicationContext(), msg.getData().getString(TOAST),
                               Toast.LENGTH_SHORT).show();
                break;
            }
        }
    };


}
