#include <stdio.h>
#include <stdlib.h>
#include <termios.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/select.h>

static int fds1[2];
static int fds2[2];

static void *tunnelfds (void *fds) {
    char *buf[4096];
    int infd, outfd;
    fd_set fda;

    infd=((int *)fds)[0];
    outfd=((int *)fds)[1];
    while(1) {
        int r;
        FD_ZERO(&fda);
        FD_SET(infd, &fda);
        r=select(infd+1, &fda, NULL, NULL, NULL);
        r=read(infd, buf, 64);
        if(r<0) sleep(1);
        if(r==0) usleep(1000);
        if(r>0) write(outfd, buf, r);
//fprintf(stderr, "%i %i\n", infd, r);
    }
    return (void *)0;
}

int main(int argc, char *argv[], char *envp[]) {
    int mx1fd, mx2fd, fd;
    pid_t pid;
    pthread_t t1, t2;
    int status;
    char name1[128], name2[128];
    struct termios ti;

    mx1fd=open("/dev/ptmx", O_RDWR);
    mx2fd=open("/dev/ptmx", O_RDWR);
    if((mx1fd<0)||(mx2fd<0)) {
        perror("/dev/ptmx");
        return -errno;
    }

    unlockpt(mx1fd);
    unlockpt(mx2fd);

    ptsname_r(mx1fd, name1, 127);
    ptsname_r(mx2fd, name2, 127);
    printf("%s\n",name2);
    if (fork()!=0) {
        exit(atoi(name2+9));
    }

    fd = open(name2, O_RDWR);
    if(fd<0) {
        perror(name2);
        return -errno;
    }
    tcgetattr(fd, &ti);
    cfmakeraw(&ti);
    tcsetattr(fd, TCSANOW, &ti);
    close(fd);

    if(!(pid=fork())) {
        argv[0]="/system/bin/pppd";
        argv[1]=name1;
        execve("/system/bin/pppd", argv, envp);
        execve("/usr/sbin/pppd", argv, envp);
    }

    fds1[0]=mx1fd;
    fds1[1]=mx2fd;
    fds2[0]=mx2fd;
    fds2[1]=mx1fd;
    pthread_create(&t1, NULL, tunnelfds, fds1);
    pthread_create(&t2, NULL, tunnelfds, fds2);

    waitpid(pid, &status, 0);

    return 0;
}
