; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "FreeMap"
!define PRODUCT_VERSION "0.9.1"
!define PRODUCT_PUBLISHER "FreeMap Israel"
!define PRODUCT_WEB_SITE "http://www.freemap.co.il"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\FreeMap.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "l:\shared\roadmap_editor\Installation\license.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\FreeMap.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Hebrew"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup.exe"
InstallDir "$PROGRAMFILES\FreeMap"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "L:\shared\roadmap_editor\src\win32\win32_env\freemap\Release\FreeMap.exe"
  CreateDirectory "$SMPROGRAMS\FreeMap"
  CreateShortCut "$SMPROGRAMS\FreeMap\FreeMap.lnk" "$INSTDIR\FreeMap.exe"
  CreateShortCut "$DESKTOP\FreeMap.lnk" "$INSTDIR\FreeMap.exe"
  File "L:\shared\roadmap_editor\src\win32\win32_env\roadgps\Release\RoadGPS.exe"
SectionEnd

Section "Config" SEC02
  SetOverwrite on
  File "L:\shared\roadmap_editor\src\drivers"
  File "L:\shared\roadmap_editor\src\win32\preferences"
  File "L:\shared\roadmap_editor\src\win32\session"
  File "L:\shared\roadmap_editor\src\win32\roadmap.toolbar"
  File "L:\shared\roadmap_editor\src\quick.menu"
  File "L:\shared\roadmap_editor\src\sprites"
  File "L:\shared\roadmap_editor\src\lang"
  File "L:\shared\roadmap_editor\src\font.ttf"
  File "L:\shared\roadmap_editor\manual\apt_toc.gif"
  File "L:\shared\roadmap_editor\manual\manual.html"
SectionEnd

Section "Maps" SEC03
  SetOutPath "$INSTDIR\maps"
  File "L:\shared\roadmap_editor\maps\usc77001.rdm"
  File "L:\shared\roadmap_editor\maps\usdir.rdm"
SectionEnd

Section "Skins" SEC04
  SetOutPath "$INSTDIR\skins\default"
  File "L:\shared\roadmap_editor\src\skins\default\about.png"
  File "L:\shared\roadmap_editor\src\skins\default\addeditnote.png"
  File "L:\shared\roadmap_editor\src\skins\default\address.png"
  File "L:\shared\roadmap_editor\src\skins\default\button_down.png"
  File "L:\shared\roadmap_editor\src\skins\default\button_up.png"
  File "L:\shared\roadmap_editor\src\skins\default\deleteroads.png"
  File "L:\shared\roadmap_editor\src\skins\default\detectreceiver.png"
  File "L:\shared\roadmap_editor\src\skins\default\down.png"
  File "L:\shared\roadmap_editor\src\skins\default\draw_roads.png"
  File "L:\shared\roadmap_editor\src\skins\default\edit.png"
  File "L:\shared\roadmap_editor\src\skins\default\key1_large_down.png"
  File "L:\shared\roadmap_editor\src\skins\default\key1_large_up.png"
  File "L:\shared\roadmap_editor\src\skins\default\key1_medium_down.png"
  File "L:\shared\roadmap_editor\src\skins\default\key1_medium_up.png"
  File "L:\shared\roadmap_editor\src\skins\default\key2_large_down.png"
  File "L:\shared\roadmap_editor\src\skins\default\key2_large_up.png"
  File "L:\shared\roadmap_editor\src\skins\default\key2_medium_down.png"
  File "L:\shared\roadmap_editor\src\skins\default\key2_medium_up.png"
  File "L:\shared\roadmap_editor\src\skins\default\left.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_approaching.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_continue.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_exit_left.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_exit_right.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_keep_left.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_keep_right.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_panel.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_panel_wide.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_turn_left.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_turn_right.png"
  File "L:\shared\roadmap_editor\src\skins\default\nav_u_turn.png"
  File "L:\shared\roadmap_editor\src\skins\default\objects"
  File "L:\shared\roadmap_editor\src\skins\default\objects_wide"
  File "L:\shared\roadmap_editor\src\skins\default\preferences.png"
  File "L:\shared\roadmap_editor\src\skins\default\properties.png"
  File "L:\shared\roadmap_editor\src\skins\default\right.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_2d.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_3d.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_clockwise.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_counterclockwise.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_destination.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_down.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_full.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_gps.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_hold.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_left.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_location.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_menu.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_new_roads.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_quit.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_record.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_right.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_stop.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_up.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_zoom1.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_zoomin.png"
  File "L:\shared\roadmap_editor\src\skins\default\rm_zoomout.png"
  File "L:\shared\roadmap_editor\src\skins\default\setasdeparture.png"
  File "L:\shared\roadmap_editor\src\skins\default\setasdestination.png"
  File "L:\shared\roadmap_editor\src\skins\default\sync.bmp"
  File "L:\shared\roadmap_editor\src\skins\default\sync.png"
  File "L:\shared\roadmap_editor\src\skins\default\traffic.png"
  File "L:\shared\roadmap_editor\src\skins\default\u_turn.png"
  File "L:\shared\roadmap_editor\src\skins\default\up.png"
  File "L:\shared\roadmap_editor\src\skins\default\updaterange.png"
  File "L:\shared\roadmap_editor\src\skins\default\viewmarkers.png"
  File "L:\shared\roadmap_editor\src\skins\default\welcome.png"
SectionEnd

Section "Day Skin" SEC041
  SetOutPath "$INSTDIR\skins\default\day"
  File /oname=schema "L:\shared\roadmap_editor\src\skins\default\schema_day"
SectionEnd

Section "Night Skin" SEC042
  SetOutPath "$INSTDIR\skins\default\night"
  File /oname=schema "L:\shared\roadmap_editor\src\skins\default\schema_night"
SectionEnd

Section "Sound" SEC05
  SetOutPath "$INSTDIR\sound"
  File "L:\shared\roadmap_editor\src\sound\200.wav"
  File "L:\shared\roadmap_editor\src\sound\800.wav"
  File "L:\shared\roadmap_editor\src\sound\Arrive.wav"
  File "L:\shared\roadmap_editor\src\sound\KeepLeft.wav"
  File "L:\shared\roadmap_editor\src\sound\KeepRight.wav"
  File "L:\shared\roadmap_editor\src\sound\m.wav"
  File "L:\shared\roadmap_editor\src\sound\Straight.wav"
  File "L:\shared\roadmap_editor\src\sound\TurnLeft.wav"
  File "L:\shared\roadmap_editor\src\sound\TurnRight.wav"
  File "L:\shared\roadmap_editor\src\sound\within.wav"
  File "L:\shared\roadmap_editor\src\sound\rec_start.wav"
  File "L:\shared\roadmap_editor\src\sound\rec_end.wav"
  File "L:\shared\roadmap_editor\src\sound\click.wav"
  File "L:\shared\roadmap_editor\src\sound\click_long.wav"
SectionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\FreeMap\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\FreeMap\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\FreeMap.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\FreeMap.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\sound\200.wav"
  Delete "$INSTDIR\sound\800.wav"
  Delete "$INSTDIR\sound\Arrive.wav"
  Delete "$INSTDIR\sound\KeepLeft.wav"
  Delete "$INSTDIR\sound\KeepRight.wav"
  Delete "$INSTDIR\sound\m.wav"
  Delete "$INSTDIR\sound\rec_end.wav"
  Delete "$INSTDIR\sound\rec_start.wav"
  Delete "$INSTDIR\sound\Straight.wav"
  Delete "$INSTDIR\sound\TurnLeft.wav"
  Delete "$INSTDIR\sound\TurnRight.wav"
  Delete "$INSTDIR\sound\within.wav"
  Delete "$INSTDIR\icons\welcome.bmp"
  Delete "$INSTDIR\icons\nav_continue.bmp"
  Delete "$INSTDIR\icons\nav_keep_left.bmp"
  Delete "$INSTDIR\icons\nav_keep_right.bmp"
  Delete "$INSTDIR\icons\nav_panel.bmp"
  Delete "$INSTDIR\icons\nav_panel_wide.bmp"
  Delete "$INSTDIR\icons\nav_turn_left.bmp"
  Delete "$INSTDIR\icons\nav_turn_right.bmp"
  Delete "$INSTDIR\icons\nav_u_turn.bmp"
  Delete "$INSTDIR\icons\rm_2d.bmp"
  Delete "$INSTDIR\icons\rm_3d.bmp"
  Delete "$INSTDIR\icons\rm_clockwise.bmp"
  Delete "$INSTDIR\icons\rm_counterclockwise.bmp"
  Delete "$INSTDIR\icons\rm_destination.bmp"
  Delete "$INSTDIR\icons\rm_full.bmp"
  Delete "$INSTDIR\icons\rm_gps.bmp"
  Delete "$INSTDIR\icons\rm_hold.bmp"
  Delete "$INSTDIR\icons\rm_location.bmp"
  Delete "$INSTDIR\icons\rm_menu.bmp"
  Delete "$INSTDIR\icons\rm_quit.bmp"
  Delete "$INSTDIR\icons\rm_record.bmp"
  Delete "$INSTDIR\icons\rm_stop.bmp"
  Delete "$INSTDIR\icons\rm_zoom1.bmp"
  Delete "$INSTDIR\icons\rm_zoomin.bmp"
  Delete "$INSTDIR\icons\rm_zoomout.bmp"
  Delete "$INSTDIR\icons\sync.bmp"
  Delete "$INSTDIR\icons\nav_approaching.bmp"
  Delete "$INSTDIR\maps\usdir.rdm"
  Delete "$INSTDIR\maps\usc77001.rdm"
  Delete "$INSTDIR\apt_toc.gif"
  Delete "$INSTDIR\manual.html"
  Delete "$INSTDIR\roadmap.toolbar"
  Delete "$INSTDIR\preferences"
  Delete "$INSTDIR\session"
  Delete "$INSTDIR\font.ttf"
  Delete "$INSTDIR\drivers"
  Delete "$INSTDIR\lang"
  Delete "$INSTDIR\objects"
  Delete "$INSTDIR\quick.menu"
  Delete "$INSTDIR\schema"
  Delete "$INSTDIR\sprites"
  Delete "$INSTDIR\RoadGPS.exe"
  Delete "$INSTDIR\FreeMap.exe"

  Delete "$SMPROGRAMS\FreeMap\Uninstall.lnk"
  Delete "$SMPROGRAMS\FreeMap\Website.lnk"
  Delete "$DESKTOP\FreeMap.lnk"
  Delete "$SMPROGRAMS\FreeMap\FreeMap.lnk"

  RMDir "$SMPROGRAMS\FreeMap"
  RMDir "$INSTDIR\sound"
  RMDir "$INSTDIR\maps"
  RMDir "$INSTDIR\icons"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd