#define UInt8 unsigned char
#define Int8 char
#define UInt16 unsigned short
#define Int16 short
#define UInt32 unsigned int
#define Int32 int

/* sound buffers */
#define NUMSNDBUFS 1600
#define SNDBUFLEN 441 /* 22050/50 */

/* hardware screen size */
#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 480
#define SCREEN_DEPTH 16
#define LINEPITCH 1600

/* spectrum screen position */
#define S_X 0
#define S_Y 50

/* keyboard position and size */
#define K_X 516
#define K_Y 190
#define K_W 280
#define K_H 104

/* user interface area position and size */
#define U_X 520
#define U_Y 10
#define U_W 280
#define U_H 100

/* colors (16 bits) */
#define COL1 0xf800
#define COL0 0x07e0
#define COL2 0x8218

/* emulation status data structure */
struct shared_t {
	void *screen;
    unsigned short *sc;
	unsigned char *ram, *rom;
    unsigned int sz53_table, halfcarry_add_table, halfcarry_sub_table,
        overflow_sub_table, overflow_add_table, parity_table, sz53p_table,
        tstates, event_next_event;
    unsigned char a, f, b, c, d, e, h, l;
    unsigned char r, a1, f1, b1, c1, d1, e1, h1, l1, i, iff1, iff2, im,
        xx1, xx2, xx3;
    unsigned short pc;
    unsigned short ix, iy, sp;
    int counter;
    unsigned int tcounter;
    unsigned char k[12];
    unsigned char out254;
    unsigned char lastborder;
    unsigned char lastsound;
    unsigned char bcount;
    unsigned char sndsample;
    unsigned int sndread;
    unsigned int sndwrite;
    unsigned char sound[SNDBUFLEN*NUMSNDBUFS];
    int scounter;
};

struct hkeys_s {
	char name[16];
	char keys[12];
};

struct ui_e {
	int x, y, w, h;
	int c;
	char name[10];
};

struct prefs_t {
    int sound;
    int kdisp;
    int fast;
	int keymode;
    unsigned char hardkeys[12];
};

struct status_t {
	int fast;
	int sndinited;
	int sndrunning;
	int sndwant;
	int pause;
	int mode;
};
